//AIM: Derive the 4 point twiddle factor matrix.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
W40=cos(0)-(sqrt(-1)*sin(0));
W41=cos(%pi/2)-(sqrt(-1))*(sin(%pi/2));
W42=cos(%pi)-(sqrt(-1))*(sin(%pi));
W43=cos((3*%pi)/2)-(sqrt(-1))*sin((3*%pi)/2);

disp(W40,'W40=')
disp(W41,'W41=')
disp(W42,'W42=')
disp(W43,'W43=')

W44=W40;
W49=W41;
W46=W42;

W4_raw_matrix= [W40 W40 W40 W40;
          W40 W41 W42 W43;
          W40 W42 W44 W46;
          W40 W43 W46 W49]
disp(W4_raw_matrix,'W4_raw_matrix=')
disp('Type resume in console and press enter')
pause
a=ceil(- 1.225D-16);
disp(a,'Imaginary part of W42 & Imaginary part of W46 i.e. ceil(- 1.225D-16)=')
b=ceil(- 1.837D-16);
disp(b,'Real part of W43 i.e. ceil(- 1.837D-16)=')
c=int(6.123D-17);
disp(c,'Real part of W41 & Real part of W49 i.e. int(6.123D-17)=')

//So W4 can be modified as follows :
d=real(W42);//Imaginary part is ignored since it is zero
e=imag(W43)*sqrt(-1);//Real part is ignored since it is zero
f=imag(W41)*(sqrt(-1));//Real part is ignored since it is zero

W4=[W40 W40 W40 W40;
          W40 f d e;
          W40 d W44 d;
          W40 e d f]
disp(W4,'Final W4 matrix =')


